-- =============================================
--  Troll action logic from the player modal is located here (callbacks, events)
-- =============================================

if (GetConvar('txEnableMenuBeta', 'false') ~= 'true') then
    return
end

local EFFECT_TIME_MS = GetConvarInt('txAdminMenu-trollDuration', 30000)
local DRUNK_ANIM_SET = "move_m@drunk@verydrunk"
local WEED_ANIM_SET = "move_m@drunk@moderatedrunk"

local DRUNK_DRIVING_EFFECTS = {
    1, -- brake
    7, --turn left + accelerate
    8, -- turn right + accelerate
    23, -- accelerate
    4, -- turn left 90 + braking
    5, -- turn right 90 + braking
}

local function getRandomDrunkCarTask()
    math.randomseed(GetGameTimer())

    return DRUNK_DRIVING_EFFECTS[math.random(#DRUNK_DRIVING_EFFECTS)]
end

-- NOTE: We might want to check if a player already has an effect
local function drunkThread()
    local playerPed = PlayerPedId()
    local isDrunk = true

    debugPrint('Starting drunk effect')
    RequestAnimSet(DRUNK_ANIM_SET)
    while not HasAnimSetLoaded(DRUNK_ANIM_SET) do
        Wait(5)
    end

    SetPedMovementClipset(playerPed, DRUNK_ANIM_SET)
    ShakeGameplayCam("DRUNK_SHAKE", 3.0)
    SetPedIsDrunk(playerPed, true)
    SetTransitionTimecycleModifier("spectator5", 10.00)

    CreateThread(function()
        while isDrunk do
            local vehPedIsIn = GetVehiclePedIsIn(playerPed)
            local isPedInVehicleAndDriving = (vehPedIsIn ~= 0) and (GetPedInVehicleSeat(vehPedIsIn, -1) == playerPed)

            if isPedInVehicleAndDriving then
                local randomTask = getRandomDrunkCarTask()
                debugPrint('Dispatching random car tasks: ' .. randomTask)
                TaskVehicleTempAction(playerPed, vehPedIsIn, randomTask, 500)
            end

            Wait(5000)
        end
    end)

    Wait(EFFECT_TIME_MS)
    debugPrint('Cleaning up drunk effect')
    isDrunk = false
    SetTransitionTimecycleModifier("default", 10.00)
    StopGameplayCamShaking(true)
    ResetPedMovementClipset(playerPed)
    RemoveAnimSet(DRUNK_ANIM_SET)
end

local function weedEffect()
    debugPrint('Starting weed effect')
    RequestAnimSet(WEED_ANIM_SET)
    while not HasAnimSetLoaded(WEED_ANIM_SET) do
        Wait(5)
    end

    SetPedMovementClipset(playerPed, WEED_ANIM_SET)
    ShakeGameplayCam("DRUNK_SHAKE", 1.0)
    SetTransitionTimecycleModifier("spectator5", 10.00)

    Wait(EFFECT_TIME_MS)

    debugPrint('Cleaning up weed effect')
    SetTransitionTimecycleModifier("default", 10.00)
    StopGameplayCamShaking(true)
    ResetPedMovementClipset(playerPed)
    RemoveAnimSet(WEED_ANIM_SET)
end


--[[ Wild Attack command ]]
local attackAnimalHashes = {
    GetHashKey("a_c_chimp"),
    GetHashKey("a_c_rottweiler"),
    GetHashKey("a_c_coyote")
}
local animalGroupHash = GetHashKey("Animal")
local playerGroupHash = GetHashKey("PLAYER")

local function startWildAttack()
    -- Consts
    local playerPed = PlayerPedId()
    local animalHash = attackAnimalHashes[math.random(#attackAnimalHashes)]
    local coordsBehindPlayer = GetOffsetFromEntityInWorldCoords(playerPed, 100, -15.0, 0)
    local playerHeading = GetEntityHeading(playerPed)
    local belowGround, groundZ, vec3OnFloor = GetGroundZAndNormalFor_3dCoord(coordsBehindPlayer.x, coordsBehindPlayer.y, coordsBehindPlayer.z)

    -- Requesting model
    RequestModel(animalHash)
    while not HasModelLoaded(animalHash) do
        Wait(5)
    end
    SetModelAsNoLongerNeeded(animalHash)

    -- Creating Animal & setting player as enemy
    local animalPed = CreatePed(1, animalHash, coordsBehindPlayer.x, coordsBehindPlayer.y, groundZ, playerHeading, true, false)
    SetPedFleeAttributes(animalPed, 0, 0)
    SetPedRelationshipGroupHash(animalPed, animalGroupHash)
    TaskSetBlockingOfNonTemporaryEvents(animalPed, true)
    TaskCombatHatedTargetsAroundPed(animalPed, 30.0, 0)
    ClearPedTasks(animalPed)
    TaskPutPedDirectlyIntoMelee(animalPed, playerPed, 0.0, -1.0, 0.0, 0)
    SetRelationshipBetweenGroups(5, animalGroupHash, playerGroupHash)
    SetRelationshipBetweenGroups(5, playerGroupHash, animalGroupHash)
end
-- RegisterCommand('atk', startWildAttack)


--[[
 Net Events
]]
RegisterNetEvent('txAdmin:menu:weedEffect', weedEffect)

RegisterNetEvent('txAdmin:menu:drunkEffect', drunkThread)

RegisterNetEvent('txAdmin:menu:setOnFire', function()
    debugPrint('Setting player on fire')
    local playerPed = PlayerPedId()
    StartEntityFire(playerPed)
end)

RegisterNetEvent('txAdmin:menu:wildAttack', function()
    startWildAttack()
end)


--[[
 NUI Callbacks
]]
RegisterNUICallback('weedEffectPlayer', function(data, cb)
    TriggerServerEvent('txAdmin:menu:weedEffectPlayer', tonumber(data.id))
    cb({})
end)

RegisterNUICallback('drunkEffectPlayer', function(data, cb)
    TriggerServerEvent('txAdmin:menu:drunkEffectPlayer', tonumber(data.id))
    cb({})
end)

RegisterNUICallback('wildAttack', function(data, cb)
    TriggerServerEvent('txAdmin:menu:wildAttack', tonumber(data.id))
    cb({})
end)

RegisterNUICallback('setOnFire', function(data, cb)
    TriggerServerEvent('txAdmin:menu:setOnFire', tonumber(data.id))
    cb({})
end)
